#include <iostream>
#include "list.h"
#include "token.h"
#include "parser.h"
#include "evaluate.h"

using namespace std;


int main (int argc, char **argv) {
	string formula = "10 + (1 + 2) + -15.9 * 2.89";
	if (argc > 1) formula = argv[1];
	cout << "formula:\"" << formula << "\"\n";

	List token_list;								// used by the Tokenize() and Parser() classes
	/*
	 * Tokenize the formula
	 */
	{
		Tokenize fsm(&token_list);						// create the FSM
		fsm.set_formula (formula);						// set the formula to parse
		int result = fsm.do_work();						// parse the formula
		cout << "result:" << result << "\n";
		fsm.print_list();								// print the tokens
	}
	
	/*
	 * Using a reverse descent parser, create a Reverse Polish Notation list.
	 * This will take the nodes from the 'token_list' and reorder them onto the 'rpn_list'
	 */
	List rdp_list;
	{
		cout << "main() " << &token_list << ":" << token_list.length() << " " << &rdp_list << ":" << rdp_list.length() << "\n";
		Parser parse (&token_list, &rdp_list);
		parse.parse();
	}
	
	/*
	 * Traverse the RPN list to calculate the result.
	 */
	Evaluate evaluate (&rdp_list);
	t_node *node = evaluate.evaluate ();
	cout << "rdp_list:" << rdp_list.length() << "\n";
	if (node->type == NT_INT) cout << "integer:" << node->integer << "\n";
	else if (node->type == NT_FLOAT) cout << "double:" << node->number << "\n";
	else cout << "type:" << node->type << "\n";

	{
		struct Node *node;
		while (node = token_list.rem_head()) { cout << "free:" << node << "\n"; free(node); }
		while (node = rdp_list.rem_head()) { cout << "free:" << node << "\n"; free(node); }
	}

	return 0;
}

