#include <iostream>
#include "list.h"
#include "token.h"
#include "color.h"
#include "evaluate.h"

using namespace std;

static void print_node (t_node *node);
static void print_list (List *list);

inline static double to_dbl (t_node *node) {
	return (node->type == NT_INT) ? node->integer : node->number;
}

t_node * Evaluate::evaluate (void) {
	t_node *node = (t_node *) list->rem_head();
	switch (node->type) {
		case NT_ADD: {
			t_node *node2 = evaluate();
			t_node *node1 = evaluate();
			t_node *result;
			if (node1->type == NT_INT && node2->type == NT_INT) {
				result = create_integer_node (node1->integer + node2->integer);
			}
			else {
				result = create_number_node (to_dbl(node1) + to_dbl(node2));
			}
			free (node1);
			free (node2);
			free (node);
			node = result;
			break;
		}
		case NT_SUB: {
			t_node *node2 = evaluate();
			t_node *node1 = evaluate();
			t_node *result;
			if (node1->type == NT_INT && node2->type == NT_INT) {
				 result = create_integer_node (node1->integer - node2->integer);
			}
			else {
				result = create_number_node (to_dbl(node1) - to_dbl(node2));
			}
			free (node1);
			free (node2);
			free (node);
			node = result;
			break;
		}
		case NT_MULT: {
			t_node *node2 = evaluate();
			t_node *node1 = evaluate();
			t_node *result;
			if (node1->type == NT_INT && node2->type == NT_INT) {
				 result = create_integer_node (node1->integer * node2->integer);
			}
			else {
				result = create_number_node (to_dbl(node1) - to_dbl(node2));
			}
			free (node1);
			free (node2);
			free (node);
			node = result;
			break;
		}
		case NT_DIV: {
			t_node *node2 = evaluate();
			t_node *node1 = evaluate();
			t_node *result;
			if (node1->type == NT_INT && node2->type == NT_INT) {
				 result = create_integer_node (node1->integer / node2->integer);
			}
			else {
				result = create_number_node (to_dbl(node1) / to_dbl(node2));
			}
			free (node1);
			free (node2);
			free (node);
			node = result;
			break;
		}
	}
	return node;
}


t_node *Evaluate::create_integer_node (long long integer) {
	t_node *node = (t_node *) malloc (sizeof(t_node));
	node->type = NT_INT;
	node->integer = integer;
	return node;
}

t_node *Evaluate::create_number_node (double number) {
	t_node *node = (t_node *) malloc (sizeof(t_node));
	node->type = NT_FLOAT;
	node->number = number;
	return node;
}



