

#include <iostream>
#include "list.h"
#include "token.h"
#include "color.h"
#include "parser.h"

//#define USE_CLASS_METHOD_PTR


#ifdef USE_CLASS_METHOD_PTR
#include <functional>
#endif

using namespace std;


static void print_node (t_node *node) {
	if (!node) { cout << "NULL"; return; }
	cout << nt_name[node->type];
	switch (node->type) {
		case NT_INT: { cout << ":" << node->integer; break; }
		case NT_FLOAT: { cout << ":" << node->number; break; }
		case NT_STRING: { cout << ":\"" << node->str << "\"";  break; }
	}
}

void print_list (List *list) {				/* debug */
	for (t_node *node = (t_node *)list->get_head(); node->node.ln_next; node = (t_node *)node->node.ln_next) {
		print_node(node);
		cout << " ";
	}
	cout << "\n";
}

// this is used in other places
#define LEVEL_START level_add_plus

int Parser::parse (void) {
	cout << name << COLOR_GREEN << ":parse()    tokens:" << token_list->length() << "    rdp:" << rdp_list->length() << "\n"  << COLOR_RESET;
	t_node *node = (t_node *) token_list->rem_head();
	if (node) {
		spaces = "";
		node = LEVEL_START (node);
	}
	cout << name << COLOR_GREEN << ":parse()    tokens:" << token_list->length() << "    rdp:" << rdp_list->length() << "\n"  << COLOR_RESET;
	
	cout << "node:"; print_node (node); cout << "\n";
	cout << "token_list:" << token_list->length() << ": "; print_list (token_list);
	cout << "rdp_list:" << rdp_list->length() << ": "; print_list (rdp_list);

	return 0;			// 0 = success
}


#ifdef USE_CLASS_METHOD_PTR
static t_node *simple_level (Parser *parser,
			t_node * (Parser::* next) (t_node *), 
			t_node *node, 
			const int type[]) {
	cout << "node type = " << nt_name[node->type] << "    [";
	for (int x = 0; type[x] != 0; x++) { cout << nt_name[type[x]] << ","; }
	cout << "]\n";

	node = invoke (next, *parser, node);						// call the next member function
	int ok = true;												// get into the loop
	while (node && ok) {
		ok = false;											// defualt to exiting the loop
		for (int x = 0; type[x] != 0; x++) {
			if (node->type == type[x]) {
				t_node *current = node;
				node = (t_node *) parser->token_list->rem_head();
				node = invoke (next, *parser, node);				// call the next member function
				parser->rdp_list->add_head (&current->node);
				ok = true;									// do another loop
				break;
			}
		}
	}
	return node;
}
#endif

#ifdef USE_CLASS_METHOD_PTR
static t_node *simple_level (Parser *parser,
			t_node * (Parser::* next) (t_node *), 
			t_node *node, 
			int type) {

	node = invoke (next, *parser, node);						// call the next member function
	cout << "node type = " << nt_name[node->type] << "    " << nt_name[type] << "\n";
	while (node && node->type == type) {
		t_node *current = node;
		node = (t_node *) parser->token_list->rem_head();
		node = invoke (next, *parser, node);					// call the next member function
		cout << "node type = " << nt_name[node->type] << "    " << nt_name[type] << "\n";
		parser->rdp_list->add_head (&current->node);
	}
	return node;
}
#endif

#ifdef USE_CLASS_METHOD_PTR
t_node *Parser::level_add_plus (t_node *node) {
	const int x[] = {NT_ADD, NT_SUB, 0};		// terminated with a zero
	//return simple_level (this, &Parser::level_mult_div, node, x);
	return simple_level (this, &Parser::level_mult_div, node, NT_ADD);
}
#else
t_node *Parser::level_add_plus (t_node *node) {
	cout << spaces << "> level_add_plus() "; print_node(node); cout << "\n";
	spaces += "  ";
	node = level_mult_div (node);
	while (node && (node->type == NT_ADD || node->type == NT_SUB)) {
		t_node *current = node;
		node = (t_node *) token_list->rem_head();
		node = level_mult_div (node);
		rdp_list->add_head (&current->node);
	}
	spaces = spaces.substr(2);
	cout << spaces << "< level_add_plus() "; print_node(node); cout << "\n";
	return node;
}
#endif

#ifdef USE_CLASS_METHOD_PTR
t_node *Parser::level_mult_div (t_node *node) {
	return simple_level (this, &Parser::level_push, node, NT_MULT);
}
#else
t_node *Parser::level_mult_div (t_node *node) {
	cout << spaces << "> level_mult_div() "; print_node(node); cout << "\n";
	spaces += "  ";
	node = level_bracket (node);
	while (node && (node->type == NT_MULT || node->type == NT_DIV)) {
		t_node *current = node;
		node = (t_node *) token_list->rem_head();
		node = level_bracket (node);
		rdp_list->add_head (&current->node);
	}
	spaces = spaces.substr(2);
	cout << spaces << "< level_mult_div() "; print_node(node); cout << "\n";;
	return node;
}
#endif

t_node *Parser::level_bracket (t_node *node) {
	cout << spaces << "> level_bracket() "; print_node(node); cout << "\n";
	spaces += "  ";
	if (node && (node->type == NT_OPEN)) {
		cout << spaces << "free:" << node << " "; print_node(node) ; cout << "\n";
		free (node);												// not interested in the OPEN token
		node = LEVEL_START ((t_node *) token_list->rem_head());			// start at the top of the chain again with the next token
		if (node->type == NT_CLOSE) {
			cout << spaces << "free:" << node << " "; print_node(node) ; cout << "\n";
			free (node);
		}
		else {
			cout << spaces << COLOR_RED << "ERROR: Not a close token!\n" << COLOR_RESET;
		}
		node = (t_node *)token_list->rem_head ();						// get the next token
	}
	else node = level_push(node);
	spaces = spaces.substr(2);
	cout << spaces << "< level_bracket() "; print_node(node); cout << "\n";
	return node;
}


t_node *Parser::level_push (t_node *node) {		/* bottom of the chain */
	cout << spaces << "> level_push() "; print_node(node); cout << "\n";
	spaces += "  ";
	rdp_list->add_head (&node->node);
	node = (t_node *) token_list->rem_head();
	spaces = spaces.substr(2);
	cout << spaces << "< level_push() "; print_node(node); cout << "\n";
	return node;
}



