#include "token.h"
#include "list.h"
#include "color.h"

using namespace std;


/*
 * These are all the state functions etc. for the FSM
 * 
 * NOTE: can't handle formulas like "1+2" yet must be like "1 + 2"
 *    maybe get the FSM to remember if there has been a preceding operand.
 *    if there has been, then this is the operand, else it is a modifier for the number.
 */

StateBase *state_start;					// needs to be global so the FSM init. can reference this state
static StateBase *state_number;
static StateBase *state_plus_minus;
static StateBase *state_mult;
static StateBase *state_float;
static StateBase *state_open;
static StateBase *state_close;
static StateBase *state_divide;

/*
 * create all the states classes, called my main().
 */
void create_all_states (void) {
	state_start = new StateStart;
	state_number = new StateNumber;
	state_plus_minus = new StateAddSub;				// needs to handle negative numbers as well
	state_mult = new StateSingleChar ('*', NT_MULT);
	state_float = new StateFloat;
	state_open = new StateSingleChar ('(', NT_OPEN);
	state_close = new StateSingleChar (')', NT_CLOSE);
	state_divide = new StateSingleChar ('/', NT_DIV);
}



/*
 * delete all the states classes, called my main().
 */
void delete_all_states (void) {
	cout << "delete_all_states()\n";
	delete state_divide;
	delete state_close;
	delete state_open;
	delete state_float;
	delete state_mult;	
	delete state_plus_minus;
	delete state_number;
	delete state_start;
}

void StateStart::work (Tokenize *fsm, const char *str) { 
	cout << name << " work() " << fsm->used << ":" << fsm->formula << "\n";
	if (fsm->formula.length() == 0) fsm->stop = true;
	else if (str[0] >= '0' && str[0] <= '9') fsm->set_state (state_number);				// change to handling the digits
	else if (str[0] == '+' || str[0] == '-') fsm->set_state (state_plus_minus);			// a '+' or '-'
	else if (str[0] == '*') fsm->set_state (state_mult);								// '*'
	else if (str[0] == '(') fsm->set_state (state_open);								// '('
	else if (str[0] == ')') fsm->set_state (state_close);								// ')'
	else if (str[0] == '/') fsm->set_state (state_divide);								// '/'
	else if (str[0] == ' ') fsm->formula = fsm->formula.substr(1);						// remove the spaces
	else fsm->stop = true;		// something unkown here
}

void StateNumber::exit (Tokenize *fsm) {
	cout << name << " exit() " << fsm->used << ":\"" << fsm->formula << "\"    save:" << save;
	long long integer = strtoll (fsm->formula.c_str(), NULL, 10);
	cout << "    " << integer;
	if (save) {
		create_integer_node (fsm, integer);
		cout << "    \"" << fsm->formula << "\"\n";
	}
}

void StateNumber::work (Tokenize *fsm, const char *str) { 
	cout << name << " work() " << str[0] << "    "  << fsm->used << ":\"" << fsm->formula << "\"\n";
	if (str[0] >= '0' && str[0] <= '9') {
		fsm->used += 1;
	}
	else if (str[0] == '.') {
		save = false;
		fsm->set_state (state_float);
	}
	else fsm->set_state (state_start);
}

void StateAddSub::exit (Tokenize *fsm) {
	cout << name << " exit() " << fsm->used << ":\"" << fsm->formula << "\"    save:" << save << "\n" ;
	if (save) create_typed_node (fsm, type);
}

void StateAddSub::work (Tokenize *fsm, const char *str) { 
	cout << name << " work() "  << str[0] << "    "  << fsm->used << ":\"" << fsm->formula << "\"    save:" << save << "\n" ;
	if (fsm->used == 0) {
		fsm->used += 1;
		type = (str[0] == '+') ? NT_ADD:NT_SUB;
	}
	else {
		if (str[0] >= '0' && str[0] <= '9') {
			save = false;
			fsm->set_state (state_number);
		}
		else fsm->set_state (state_start);
	}
}

void StateFloat::exit (Tokenize *fsm) {
	cout << name << " exit() " << fsm->used << ":\"" << fsm->formula << "\"";
	double number = strtod (fsm->formula.c_str(), NULL);
	cout << "    number:" << number << "\n";
	t_node *node = (t_node *) malloc (sizeof (t_node));
	node->type = NT_FLOAT;
	node->number = number;
	fsm->list->add_tail (&node->node);
	fsm->formula = fsm->formula.substr(fsm->used);
	fsm->used = 0;
}

void StateFloat::work (Tokenize *fsm, const char *str) { 
	cout << name << " work() " << str[0] << "    "  << fsm->used << ":\"" << fsm->formula << "\"\n";
	if (str[0] == '.' || (str[0] >= '0' && str[0] <= '9')) 
		fsm->used += 1;
	else 
		fsm->set_state (state_start);
	
}

void StateSingleChar::exit (Tokenize *fsm) {
	cout << name << " exit() " << fsm->used << ":\"" << fsm->formula << "\"";
	create_typed_node (fsm, nt_type);
	cout << "    " << fsm->formula.length() << "\"" << fsm->formula << "\"\n";
}

void StateSingleChar::work (Tokenize *fsm, const char *str) { 
	cout << name << " work() " << str[0] << "    "  << fsm->used << ":\"" << fsm->formula << "\"    " << find << ":" << nt_type << "\n";
	fsm->used = 1;
	fsm->set_state (state_start);
}




